using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Diagnostics;
using System.Drawing.Printing;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;
using System.ServiceProcess; // CR 3419
//using SpeechLib; CR 2930
using System.Text;


using Microsoft.Win32;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/22/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Common functions used by VBECS</summary>

	#endregion

	public class Utility
	{
		private const string DescSortOrderSuffixString = " DESC"; // Please note that the space before "desc" has to be there.

        // CR 3419 start
        private const string ProdHL7Service = "VBECS Prod HL7 Listener";
        private const string TestHL7Service = "VBECS Test HL7 Listener";
        private const string ProdVistaService = "VBECS Prod VistALink Listener";
        private const string TestVistaService = "VBECS Test VistALink Listener";
        private const string ProdHL7Dispatcher = "VBECS Prod HL7 Dispatcher";
        private const string TestHL7Dispatcher = "VBECS Test HL7 Dispatcher";
        // CR 3419 end

		private static Assembly entryAssembly = Assembly.GetEntryAssembly();

		private static Hashtable speakTextResultLookup = new Hashtable();

		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2235"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>boolean</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2244"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsDefaultPrinterConfigured
		/// </summary>
		public static bool IsDefaultPrinterConfigured
		{
			get
			{			
				string defaultPrinter = new PrintDocument().PrinterSettings.PrinterName;

				return defaultPrinter.Trim() != "<no default printer>";
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2215"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string from AssemblyInfo</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="722"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Last compilation date.
		/// </summary>
		/// <returns>string</returns>
		public static string CompileDate
		{	
			get 
			{
				try
				{
					FileInfo fo = new FileInfo(entryAssembly.CodeBase.Replace("file:///",""));
					return VBECSDateTime.FormatDateTimeString(fo.LastWriteTime);
				}
				catch
				{
					return String.Empty;
				}
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5837"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>Non-null string.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5838"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Descending order sort suffix to use in sort expressions.
		/// </summary>
		public static string DescSortOrderSuffix
		{
			get
			{
				return DescSortOrderSuffixString;
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="723"> 
		///		<ExpectedInput>Debug code - no tests needed</ExpectedInput>
		///		<ExpectedOutput>Debug code - no tests needed</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="724"> 
		///		<ExpectedInput>Debug code - no tests needed</ExpectedInput>
		///		<ExpectedOutput>Debug code - no tests needed</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This will write to a textfile all the data bein send to TransactionGetValue (arraylist only)
		/// </summary>
		/// <param name="sprocList"></param>
		/// <param name="dtList"></param>
		/// <param name="fileName"></param>
		public static void DumpTransactionalInputs(System.Collections.ArrayList sprocList, System.Collections.ArrayList dtList, string fileName)
		{
			if (fileName.Trim().Length == 0) fileName = "output.txt";

			//Create a textfile that can be imported into XLS to verify data
			System.IO.StreamWriter sw = new System.IO.StreamWriter("C:\\" + fileName,false);

			//Loop through each of the stored procedures
			for (int ndx=0; ndx < sprocList.Count; ndx++)
			{
				System.Data.DataTable dtOut = (System.Data.DataTable)dtList[ndx];

				sw.WriteLine(sprocList[ndx].ToString());

				//Dump out the column names
				for (int ndx2=0; ndx2 < dtOut.Columns.Count; ndx2++)
				{
					sw.Write(dtOut.Columns[ndx2].ColumnName + "\t");
				}
				sw.Write("\n");		//carriage return the column header line

				//Dump out all the datarows 
				foreach(System.Data.DataRow dr in dtOut.Rows)
				{
					for (int ndx2=0; ndx2 < dtOut.Columns.Count; ndx2++)
					{
						sw.Write(dr[ndx2].ToString() + "\t");
					}
					sw.Write("\n");	//carriage return the data line
				}
				sw.WriteLine(string.Empty);
			}

			sw.Close();
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2216"> 
		///		<ExpectedInput>Valid System.Type</ExpectedInput>
		///		<ExpectedOutput>Valid SqlDBType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2217"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to determine the type of the db column.
		/// </summary>
		/// <param name="inType">Type</param>
		/// <returns>SqlDbType</returns>
		public static SqlDbType GetColumnType(System.Type inType)
		{
			switch( inType.ToString() ) 
			{
				case "System.Binary"   : return SqlDbType.Binary;
				case "System.Boolean"  : return SqlDbType.Bit;
				case "System.Byte[]"   : return SqlDbType.Binary;
				case "System.Byte"     : return SqlDbType.TinyInt;
				case "System.Guid"     : return SqlDbType.UniqueIdentifier;
				case "System.String"   : return SqlDbType.VarChar;
				case "System.Int32"    : return SqlDbType.Int;
				case "System.Int64"	   : return SqlDbType.BigInt;	// CR 2431	added Int64 check to allow for Bigint datatype in database
				case "System.Decimal"  : return SqlDbType.Decimal;
				case "System.DateTime" : return SqlDbType.DateTime;
				case "System.Char"     : return SqlDbType.Char;
				default                : return SqlDbType.VarChar;
			}
		} 
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2900"> 
		///		<ExpectedInput>char</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2901"> 
		///		<ExpectedInput>Invalid char</ExpectedInput>
		///		<ExpectedOutput>char.MinValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the int representing Donation Type from a character.
		/// </summary>
		/// <param name="donationType"></param>
		/// <returns>int representation of supplied donation type.</returns>
		public static int GetDonationTypeIdFromChar(char donationType)
		{
			switch( donationType )
			{
				case '0' : return 1;
				case 'V' : return 2;
				case 'R' : return 3;
				case 'S' : return 4;
				case 'T' : return 5;
				case 'P' : return 6;
				case 'r' : return 7;
				case 's' : return 8;
				case 'A' : return 9;
				case '1' : return 10;
				case 'X' : return 11;
				case 'D' : return 12;
				case 'd' : return 13;
				case '2' : return 14;
				case 'L' : return 15;
				case 'E' : return 16;
				case 'Q' : return 17;
				case '3' : return 18;
				case '4' : return 19;
				case '5' : return 20;
				default  : return Char.MinValue;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2222"> 
		///		<ExpectedInput>Valid Barcode type</ExpectedInput>
		///		<ExpectedOutput>Valid Barchode character</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2223"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representing Barcode Type from an enumeration.
		/// </summary>
		/// <param name="barcodeType"></param>
		/// <returns></returns>
		public static char GetBarcodeTypeCodeCharFromEnum(BarcodeType barcodeType)
		{
			switch( barcodeType )
			{
				case BarcodeType.Codabar : return 'C';
				case BarcodeType.ISBT128 : return 'I';
				default                  : return Char.MinValue;
			}
		}

		///<Developers>
		///	<Developer>COE User</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2902"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>BarcodeType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2903"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representing Barcode Type from a string.
		/// </summary>
		/// <param name="barcodeTypeString"></param>
		/// <returns>enumeration representing barcode type</returns>
		public static BarcodeType GetBarcodeTypeFromString(string barcodeTypeString)
		{
			switch( barcodeTypeString )
			{
				case "C" : return BarcodeType.Codabar;
				case "I" : return BarcodeType.ISBT128;
				default  : return BarcodeType.None;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/1/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="826"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>LocationType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2227"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Public static function to return a location type based on a given string.
		/// </summary>
		/// <param name="locationTypeString">String to convert to location type.</param>
		/// <returns>Location type of string.</returns>
		public static LocationType GetLocationTypeFromString(string locationTypeString)
		{
			switch( locationTypeString )
			{
				case "I" : return LocationType.Inpatient;
				case "O" : return LocationType.Outpatient;
				case "X" : return LocationType.Other;
				default  : return LocationType.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2228"> 
		///		<ExpectedInput>RecordStatusCode</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2229"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representing Record Status Code an enumeration.
		/// </summary>
		/// <param name="recordStatus"></param>
		/// <returns>char representation of the Record Status Code</returns>
		public static char GetRecordStatusCodeCharFromEnum(RecordStatusCode recordStatus)
		{
			switch( recordStatus )
			{
				case RecordStatusCode.Active           : return 'A';
				case RecordStatusCode.Converted        : return 'C';
				case RecordStatusCode.ErrorCorrected   : return 'E';
				case RecordStatusCode.Historical       : return 'H';
				case RecordStatusCode.Incomplete       : return 'I';
				case RecordStatusCode.LocalEntry       : return 'L';
				case RecordStatusCode.NationalStandard : return 'N';
				case RecordStatusCode.Modified		   : return 'M';
				case RecordStatusCode.Inactive         : return 'X';
				default                                : return 'U';
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2904"> 
		///		<ExpectedInput>DonationType</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2905"> 
		///		<ExpectedInput>Unknown DonationType</ExpectedInput>
		///		<ExpectedOutput>U</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of Donation Type from an enumeration.
		/// </summary>
		/// <param name="donationType"></param>
		/// <returns></returns>
		public static char GetDonationTypeCodeCharFromEnum(DonationType donationType)
		{
			switch( donationType )
			{
				case DonationType.VolunteerAllogeneicDonor                : return 'V';
				case DonationType.VolunteerResearchDonor                  : return 'R';
				case DonationType.VolunteerSourceDonor                    : return 'S';
				case DonationType.VolunteerTherapeuticCollection          : return 'T';
				case DonationType.PaidAllogeneicCollection                : return 'P';
				case DonationType.PaidResearchCollection                  : return 'r';
				case DonationType.PaidSourceCollection                    : return 's';
				case DonationType.AutologousEligibleForCrossover          : return 'A';
				case DonationType.ForAutologousUseOnly                    : return '1';
				case DonationType.ForAutologousUseOnlyBiohazardous        : return 'X';
				case DonationType.VolunteerDirectedEligibeForCrossover    : return 'D';
				case DonationType.PaidDirectedEligibleForCrossover        : return 'd';
				case DonationType.ForDirectedDonorUseOnly                 : return '2';
				case DonationType.ForDirectedDonorUseOnlyLimitedExposure  : return 'L';
				case DonationType.ForDirectedDonorUseOnlyMedicalException : return 'E';
				case DonationType.SeeSpecialTestingBarcode                : return 'Q';
				case DonationType.ForDirectedDonorUseOnlyBiohazardous     : return '3';
				case DonationType.DesignatedDonor                         : return '4';
				case DonationType.DedicatedDonor                          : return '5';
				default                                                   : return 'U';
			}
		}

		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2906"> 
		///		<ExpectedInput>char</ExpectedInput>
		///		<ExpectedOutput>DonationType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2907"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Donation Type from a char.
		/// </summary>
		/// <param name="donationType"></param>
		/// <returns></returns>
		public static DonationType GetDonationTypeCodeEnumFromChar(char donationType)
		{
			switch( donationType )
			{
				case 'V' : return DonationType.VolunteerAllogeneicDonor;
				case 'R' : return DonationType.VolunteerResearchDonor;
				case 'S' : return DonationType.VolunteerSourceDonor;
				case 'T' : return DonationType.VolunteerTherapeuticCollection;
				case 'P' : return DonationType.PaidAllogeneicCollection;
				case 'r' : return DonationType.PaidResearchCollection;
				case 's' : return DonationType.PaidSourceCollection;
				case 'A' : return DonationType.AutologousEligibleForCrossover;
				case '1' : return DonationType.ForAutologousUseOnly;
				case 'X' : return DonationType.ForAutologousUseOnlyBiohazardous;
				case 'D' : return DonationType.VolunteerDirectedEligibeForCrossover;
				case 'd' : return DonationType.PaidDirectedEligibleForCrossover;
				case '2' : return DonationType.ForDirectedDonorUseOnly;
				case 'L' : return DonationType.ForDirectedDonorUseOnlyLimitedExposure;
				case 'E' : return DonationType.ForDirectedDonorUseOnlyMedicalException;
				case 'Q' : return DonationType.SeeSpecialTestingBarcode;
				case '3' : return DonationType.ForDirectedDonorUseOnlyBiohazardous;
				case '4' : return DonationType.DesignatedDonor;
				case '5' : return DonationType.DedicatedDonor;
				default  : return DonationType.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2230"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>RecordStatusCode</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2231"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Record Status Code from a string.
		/// </summary>
		/// <param name="recordStatusString"></param>
		/// <returns>Enumeration representation of Record Status Code</returns>
		public static RecordStatusCode GetRecordStatusCodeFromString(string recordStatusString)
		{
			switch( recordStatusString )
			{
				case "A" : return RecordStatusCode.Active;
				case "C" : return RecordStatusCode.Converted;
				case "E" : return RecordStatusCode.ErrorCorrected;
				case "H" : return RecordStatusCode.Historical;
				case "I" : return RecordStatusCode.Incomplete;
				case "L" : return RecordStatusCode.LocalEntry;
				case "N" : return RecordStatusCode.NationalStandard;
				case "X" : return RecordStatusCode.Inactive;
				case "M" : return RecordStatusCode.Modified;
				default  : return RecordStatusCode.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2232"> 
		///		<ExpectedInput>UnitStatusCode</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2233"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the string representation of a Unit Status Code from an enumeration.
		/// </summary>
		/// <param name="unitStatus"></param>
		/// <returns>string representation of unit status code</returns>
		public static string GetUnitStatusTextFromEnum(UnitStatusCode unitStatus)
		{
			switch( unitStatus )
			{
				case UnitStatusCode.Available            : return "Available";
				case UnitStatusCode.CrossmatchedAssigned : return "Crossmatched";
				case UnitStatusCode.Discarded            : return "Discarded";
				case UnitStatusCode.Issued               : return "Issued";
				case UnitStatusCode.Limited              : return "Limited";
				case UnitStatusCode.Modified             : return "Modified";
				case UnitStatusCode.Transferred          : return "Transferred";
				case UnitStatusCode.Transfused           : return "Transfused";
				case UnitStatusCode.Assigned             : return "Assigned";
				default                                  : return "Unknown";
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2236"> 
		///		<ExpectedInput>UnitStatusCode</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2237"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of a Unit Status Code from an enumeration.
		/// </summary>
		/// <param name="unitStatus"></param>
		/// <returns>char representation of unit status code</returns>
		public static char GetUnitStatusCodeCharFromEnum(UnitStatusCode unitStatus)
		{
			switch( unitStatus )
			{
				case UnitStatusCode.Available            : return 'A';
				case UnitStatusCode.CrossmatchedAssigned : return 'C';
				case UnitStatusCode.Discarded            : return 'D';
				case UnitStatusCode.Issued               : return 'I';
				case UnitStatusCode.Limited              : return 'L';
				case UnitStatusCode.Modified             : return 'M';
				case UnitStatusCode.Transfused           : return 'T';
				case UnitStatusCode.Transferred          : return 'X';
				case UnitStatusCode.Assigned             : return 'S';
				default                                  : return 'U';
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2238"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>UnitStatusCode</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2239"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Unit Status Code from a string.
		/// </summary>
		/// <param name="unitStatusString"></param>
		/// <returns>enumeration representation of the unit status code</returns>
		public static UnitStatusCode GetUnitStatusCodeFromString(string unitStatusString)
		{
			switch( unitStatusString )
			{
				case "A" : return UnitStatusCode.Available;
				case "C" : return UnitStatusCode.CrossmatchedAssigned;
				case "D" : return UnitStatusCode.Discarded;
				case "I" : return UnitStatusCode.Issued;
				case "L" : return UnitStatusCode.Limited;
				case "M" : return UnitStatusCode.Modified;
				case "T" : return UnitStatusCode.Transfused;
				case "X" : return UnitStatusCode.Transferred;
				case "S" : return UnitStatusCode.Assigned;
				default  : return UnitStatusCode.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2241"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>QuarantineComment</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2243"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Quarantine comment from a string.
		/// </summary>
		/// <param name="quarantine"></param>
		/// <returns>enumeration representation of a Quarantine Comment</returns>
		public static QuarantineComment GetQuarantineEnum(string quarantine) 
		{
			switch( quarantine )
			{
				case "I" : return QuarantineComment.IncompleteDonorScreeningTest;
				case "P" : return QuarantineComment.PositiveDonorScreeningTest;
				case "S" : return QuarantineComment.StorageOutsideMonitoredArea;
				case "V" : return QuarantineComment.VisualInspectionUnsatisfactory;
				case "A" : return QuarantineComment.ABOInconclusive;
				case "O" : return QuarantineComment.Other;
				default  : return QuarantineComment.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2246"> 
		///		<ExpectedInput>QuarantineComment</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2247"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of a Quarantine Comment from an enumeration.
		/// </summary>
		/// <param name="quarantine"></param>
		/// <returns>char representation of a quarantine comment</returns>
		public static char GetQuarantineCharFromEnum(QuarantineComment quarantine) 
		{
			switch( quarantine )
			{
				case QuarantineComment.ABOInconclusive                : return 'A';
				case QuarantineComment.IncompleteDonorScreeningTest   : return 'I';
				case QuarantineComment.PositiveDonorScreeningTest     : return 'P';
				case QuarantineComment.StorageOutsideMonitoredArea    : return 'S';
				case QuarantineComment.VisualInspectionUnsatisfactory : return 'V';
				case QuarantineComment.Other                          : return 'O';
				default                                               : return 'U';
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2250"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>DiscardComment</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2251"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Discard Comment from a string.
		/// </summary>
		/// <param name="discard"></param>
		/// <returns>enumeration representation of Discard Comment</returns>
		public static DiscardComment GetDiscardEnum(string discard) 
		{
			switch( discard )
			{
				case "D" : return DiscardComment.DispositionForResearch;
				case "I" : return DiscardComment.Incinerated;
				case "P" : return DiscardComment.Punctured;
				case "R" : return DiscardComment.RupturedDuringThaw;
				case "O" : return DiscardComment.Other;
				default  : return DiscardComment.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2252"> 
		///		<ExpectedInput>DiscardComment</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2253"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of a Discard Comment from an enumeration.
		/// </summary>
		/// <param name="discard"></param>
		/// <returns>char representation of Discard Comment</returns>
		public static char GetDiscardCharFromEnum(DiscardComment discard) 
		{
			switch( discard )
			{
				case DiscardComment.DispositionForResearch : return 'D';
				case DiscardComment.Incinerated            : return 'I';
				case DiscardComment.Punctured              : return 'P';
				case DiscardComment.RupturedDuringThaw     : return 'R';
				case DiscardComment.Other                  : return 'O';
				default                                    : return 'U';
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2258"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>ReportType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2259"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces>t</Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Unit Status Code from a string.
		/// </summary>
		/// <param name="reportType"></param>
		/// <returns>enumeration representation of report type</returns>
		public static ReportType GetReportTypeFromInt(int reportType)
		{
			switch( reportType )
			{
				case 1  : return ReportType.AuditTrail;
				case 2  : return ReportType.CostAccounting;
				case 3  : return ReportType.DivisionInventory;
				case 4  : return ReportType.DownTime;
				case 5  : return ReportType.DivisionWorkload;
				case 6  : return ReportType.Exception;
				case 7  : return ReportType.TransfusionComplication;
				case 8  : return ReportType.TransfusionEffectiveness;
				case 9  : return ReportType.InappropriateTransfusionRequest;
				default : return ReportType.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4104"> 
		///		<ExpectedInput>ProductModification</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4125"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces>t</Interfaces>
		/// <summary>
		/// Returns the char equivilant of the ProductModification enum value
		/// </summary>
		/// <param name="modType"></param>
		/// <returns></returns>
		public static char GetProductModificationCharFromEnum(ProductModification modType)
		{
			switch( modType )
			{
				case ProductModification.Thawed         : return 'T';
				case ProductModification.Pooled         : return 'P';
				case ProductModification.PoolThawCryo   : return 'U';
				case ProductModification.SplitAdult     : return 'S';
				case ProductModification.Irradiated     : return 'I';
				case ProductModification.LeukoReduced   : return 'L';
				case ProductModification.VolumeReduced  : return 'V';
				case ProductModification.Washed         : return 'W';
				case ProductModification.Rejuvenated    : return 'R';
				case ProductModification.Frozen         : return 'F';
				case ProductModification.Deglycerolized : return 'D';
				default                                 : return ' ';
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4020"> 
		///		<ExpectedInput>WorkloadEventStatus</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4025"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces>t</Interfaces>
		/// <summary>
		/// Converts enum to char for workload event status code.
		/// </summary>
		/// <param name="workloadEventStatusCode"></param>
		/// <returns></returns>
		public static char GetWorkloadEventStatusCodeCharFromEnum(WorkloadEventStatus workloadEventStatusCode)
		{
			switch( workloadEventStatusCode )
			{
				case WorkloadEventStatus.Error                : return 'E';
				case WorkloadEventStatus.InProcess            : return 'I';
				case WorkloadEventStatus.PendingProcessing    : return 'P';
				case WorkloadEventStatus.SucessfullyProcessed : return 'S';
				default                                       : return 'U';
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2245"> 
		///		<ExpectedInput>char</ExpectedInput>
		///		<ExpectedOutput>WorkloadEventStatus</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2248"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces>t</Interfaces>
		/// <summary>
		/// Converts a workloadeventstatuscode char to an enum
		/// </summary>
		/// <param name="eventStatusCode"></param>
		/// <returns></returns>
		public static WorkloadEventStatus GetWorkloadEventStatusCodeEnumFromChar(char eventStatusCode)
		{
			switch( eventStatusCode )
			{
				case 'E' : return WorkloadEventStatus.Error;
				case 'I' : return WorkloadEventStatus.InProcess;
				case 'P' : return WorkloadEventStatus.PendingProcessing;
				case 'S' : return WorkloadEventStatus.SucessfullyProcessed;
				default  : return WorkloadEventStatus.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2449"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>ProductModification</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2450"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Product Modification from a string.
		/// </summary>
		/// <param name="modificationType"></param>
		/// <returns>enumeration representation of a Product Modification</returns>
		public static ProductModification GetProductModificationCodeFromString(string modificationType)
		{
			switch( modificationType )
			{
				case "T" : return ProductModification.Thawed;
				case "P" : return ProductModification.Pooled;
				case "U" : return ProductModification.PoolThawCryo;
				case "S" : return ProductModification.SplitAdult;
				case "I" : return ProductModification.Irradiated;
				case "L" : return ProductModification.LeukoReduced;
				case "V" : return ProductModification.VolumeReduced;
				case "W" : return ProductModification.Washed;
				case "R" : return ProductModification.Rejuvenated;
				case "F" : return ProductModification.Frozen;
				case "D" : return ProductModification.Deglycerolized;
				default  : return ProductModification.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2058"> 
		///		<ExpectedInput>ProductModification</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2059"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces>t</Interfaces>
		/// <summary>
		/// Returns the text description of ProductModification enum value
		/// </summary>
		/// <param name="modType"></param>
		/// <returns></returns>
		public static string GetProductModificationTextFromEnum(ProductModification modType)
		{
			switch( modType )
			{
				case ProductModification.Thawed         : return "thaw";
				case ProductModification.Pooled         : return "pool";
				case ProductModification.PoolThawCryo   : return "pool/thaw"; // TODO: there's can be an error here... \t is a tab character. use @ to make verbatim
				case ProductModification.SplitAdult     : return "split";
				case ProductModification.Irradiated     : return "irradiate";
				case ProductModification.LeukoReduced   : return "leuko reduce";
				case ProductModification.VolumeReduced  : return "volume reduce";
				case ProductModification.Washed         : return "wash";
				case ProductModification.Rejuvenated    : return "rejuvenate";
				case ProductModification.Frozen         : return "freeze";
				case ProductModification.Deglycerolized : return "deglycerolize";
				case ProductModification.EditPool       : return "edit pool";
				default                                 : return "unknown";
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2263"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>SpecimenType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2264"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Specimen Type from a string.
		/// </summary>
		/// <param name="specimenType"></param>
		/// <returns></returns>
		public static SpecimenType GetSpecimenTypeFromString(string specimenType)
		{
			switch( specimenType.ToUpper().Trim() )
			{
				case "BLOOD"  : return SpecimenType.Blood;
				case "PLASMA" : return SpecimenType.Plasma;
				case "SERUM"  : return SpecimenType.Serum;
				default       : return SpecimenType.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2266"> 
		///		<ExpectedInput>ModifyUnitMethod</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2267"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of a Modification Method from an enumeration.
		/// </summary>
		/// <param name="modificationMethod"></param>
		/// <returns>char representation of a Modification Method</returns>
		public static char GetModificationMethodCharFromEnum(ModifyUnitMethod modificationMethod)
		{
			switch( modificationMethod )
			{
				case ModifyUnitMethod.Closed                  : return 'C';
				case ModifyUnitMethod.SterileConnectingDevice : return 'S';
				case ModifyUnitMethod.Open                    : return 'O';
				default                                       : return Char.MinValue;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="729"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>ModifyUnitMethod</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="730"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the Modification Method Enum value of a string code
		/// </summary>
		/// <param name="modificationMethodCode"></param>
		/// <returns></returns>
		public static ModifyUnitMethod GetModificationMethodEnumFromString(string modificationMethodCode)
		{
			// Just in case a fowl string has been sent in -- this avoids the crapout on the switchstatement
			if ( modificationMethodCode.Trim().Length == 0 )
				return ModifyUnitMethod.None;
			
			switch( modificationMethodCode[0] )
			{
				case 'C' : return ModifyUnitMethod.Closed;
				case 'S' : return ModifyUnitMethod.SterileConnectingDevice;
				case 'O' : return ModifyUnitMethod.Open;
				default  : return ModifyUnitMethod.None;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2268"> 
		///		<ExpectedInput>ShipmentDirection</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2269"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the shipment direction.
		/// </summary>
		/// <param name="shipment"></param>
		/// <returns>bool representing the shipment direction</returns>
		public static bool GetShipmentDirectionFromEnum(ShipmentDirection shipment)
		{
			return shipment == ShipmentDirection.IncomingShipment;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2270"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>ShipmentDirection</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="731"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the shipment direction.
		/// </summary>
		/// <param name="shipment"></param>
		/// <returns>enumeration representing the shipment direction</returns>
		public static ShipmentDirection GetShipmentDirectionFromBool(bool shipment)
		{
			return shipment ? ShipmentDirection.IncomingShipment : ShipmentDirection.OutgoingShipment;
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2908"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>TransfusionRequirementCategoryCode</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2909"> 
		///		<ExpectedInput>Invalid string</ExpectedInput>
		///		<ExpectedOutput>TransfusionRequirementCategoryCode.Unknown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a Transfusion Requirement from a string.
		/// </summary>
		/// <param name="code"></param>
		/// <returns>enumeration representing the Transfusion Requirement</returns>
		public static TransfusionRequirementCategoryCode GetTransfusionCategoryCodeFromString(string code)
		{
			switch( code )
			{
				case "CR" : return TransfusionRequirementCategoryCode.ComponentRequirement;
				case "AN" : return TransfusionRequirementCategoryCode.AntigenNegative;
				case "AS" : return TransfusionRequirementCategoryCode.AntibodyIdentified;
				default   : return TransfusionRequirementCategoryCode.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2910"> 
		///		<ExpectedInput>TransfusionRequirementCategoryCode</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2911"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the string representation of a Transfusion Category Code from an enumeration.
		/// </summary>
		/// <param name="code"></param>
		/// <returns>string representing the Transfusion Category Code</returns>
		public static String GetTransfusionCategoryCodeFromEnum(TransfusionRequirementCategoryCode code)
		{
			switch( code )
			{
				case TransfusionRequirementCategoryCode.ComponentRequirement : return "CR";
				case TransfusionRequirementCategoryCode.AntigenNegative		 : return "AN";
				case TransfusionRequirementCategoryCode.AntibodyIdentified   : return "AS";
				default                                                      : return String.Empty;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2274"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>ProductType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2275"> 
		///		<ExpectedInput>Invalid string</ExpectedInput>
		///		<ExpectedOutput>Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Product Type from a string.
		/// </summary>
		/// <param name="productTypeCode"></param>
		/// <returns>enumeration representing Product Type</returns>
		public static ProductType GetProductTypeFromProductTypeCode(string productTypeCode)
		{
			return (ProductType)Convert.ToInt32( productTypeCode.Replace( "E","" ) );
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2278"> 
		///		<ExpectedInput>ProductType</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4126"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the string representation of Product Type from an enumeration.
		/// </summary>
		/// <param name="productType"></param>
		/// <returns></returns>
		public static string GetProductTypeCodeFromProductTypeEnum(ProductType productType)
		{
			string productTypeCode = "00" + Convert.ToInt32( productType ).ToString();
			return "E" + productTypeCode.Substring( productTypeCode.Length - 3, 3 );
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2276"> 
		///		<ExpectedInput>TestEntryMethod</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2277"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of Test Entry Method from an enumeration.
		/// </summary>
		/// <param name="testEntryMethod"></param>
		/// <returns>char representation of Test Entry Method</returns>
		public static string GetTestEntryMethodCodeFromTestEntryMethodEnum(TestEntryMethod testEntryMethod)
		{
			return testEntryMethod == TestEntryMethod.Manual ? "M" : String.Empty;
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2280"> 
		///		<ExpectedInput>Sex</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2281"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of Sex from an enumeration.
		/// </summary>
		/// <param name="sex"></param>
		/// <returns>char representation of sex</returns>
		public static char GetSexCodeFromSexEnum(Sex sex)
		{
			switch( sex )
			{
				case Sex.Male   : return 'M';
				case Sex.Female : return 'F';
				default         : return 'U';
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2283"> 
		///		<ExpectedInput>char</ExpectedInput>
		///		<ExpectedOutput>Sex</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2284"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Sex from a char.
		/// </summary>
		/// <param name="sex"></param>
		/// <returns>enumeration representing Sex</returns>
		public static Sex GetSexEnumFromSexChar(char sex)
		{
			switch( sex )
			{
				case 'M' : return Sex.Male;
				case 'F' : return Sex.Female;
				default  : return Sex.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/19/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2805"> 
		///		<ExpectedInput>OrderStatus</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2806"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of Order Status from an enumeration.
		/// </summary>
		/// <param name="orderStatus"></param>
		/// <returns>char representing Order Status</returns>
		public static char GetOrderStatusCodeFromEnum(OrderStatus orderStatus)
		{
			switch( orderStatus )
			{
				case OrderStatus.Accepted  : return 'A';
				case OrderStatus.Complete  : return 'C';
				case OrderStatus.Hold      : return 'H';
				case OrderStatus.Pending   : return 'P';
				case OrderStatus.Cancelled : return 'X';
				default                    : return Char.MinValue;
			}
		}
		
		///<Developers>
		///	<Developer>COE User</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2912"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>OrderStatus</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2913"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Order Status from a string.
		/// </summary>
		/// <param name="orderStatus"></param>
		/// <returns>enumeration representing Order Status</returns>
		public static OrderStatus GetOrderStatusCodeFromString(string orderStatus)
		{
			switch( orderStatus )
			{
				case "A" : return OrderStatus.Accepted;
				case "C" : return OrderStatus.Complete;
				case "H" : return OrderStatus.Hold;
				case "P" : return OrderStatus.Pending;
				case "X" : return OrderStatus.Cancelled;
				default  : return OrderStatus.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="733"> 
		///		<ExpectedInput>OrderUrgency</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="734"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This method is used to get the char representation of Order Urgency from an enumeration.
		/// </summary>
		/// <param name="orderUrgency"></param>
		/// <returns>char representing Order Urgency</returns>
		public static char GetOrderUrgencyCodeFromEnum(OrderUrgency orderUrgency)
		{
			switch( orderUrgency )
			{
				case OrderUrgency.ASAP    : return 'A';
				case OrderUrgency.PreOp   : return 'P';
				case OrderUrgency.Routine : return 'R';
				case OrderUrgency.STAT    : return 'S';
				default                   : return Char.MinValue;
			}
		}
		
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="735"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>OrderUrgency</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="736"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This method is used to get the enumeration representation of Order Urgency from a string.
		/// </summary>
		/// <param name="orderUrgency"></param>
		/// <returns>enumeration representing Order Urgency</returns>
		public static OrderUrgency GetOrderUrgencyCodeFromString(string orderUrgency)
		{
			switch( orderUrgency )
			{
				case "A" : return OrderUrgency.ASAP;
				case "P" : return OrderUrgency.PreOp;
				case "R" : return OrderUrgency.Routine;
				case "S" : return OrderUrgency.STAT;
				default  : return OrderUrgency.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/19/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2807"> 
		///		<ExpectedInput>TaskStatus</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2808"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of Task Status Code from an enumeration.
		/// </summary>
		/// <param name="taskStatus"></param>
		/// <returns>char representing Task Status Code</returns>
		public static char GetTaskStatusCodeFromEnum(TaskStatus taskStatus)
		{
			switch( taskStatus )
			{
				case TaskStatus.Completed          : return 'C';
				case TaskStatus.Expired            : return 'E';
				case TaskStatus.Filled             : return 'F';
				case TaskStatus.InProgress         : return 'I';
				case TaskStatus.NotStarted         : return 'N';
				case TaskStatus.PartiallyCompleted : return 'P';
				case TaskStatus.ResultsCorrected   : return 'R';
				default                            : return Char.MinValue;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2914"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>TaskStatus</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2915"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Task Status Code from a string.
		/// </summary>
		/// <param name="taskStatus"></param>
		/// <returns>enumeration representing Task Status Code</returns>
		public static TaskStatus GetTaskStatusCodeFromString(string taskStatus)
		{
			switch( taskStatus )
			{
				case "C" : return TaskStatus.Completed;
				case "E" : return TaskStatus.Expired;
				case "F" : return TaskStatus.Filled;
				case "I" : return TaskStatus.InProgress;
				case "N" : return TaskStatus.NotStarted;
				case "P" : return TaskStatus.PartiallyCompleted;
				case "R" : return TaskStatus.ResultsCorrected;
				default  : return TaskStatus.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2916"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>SpecimenStatus</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2917"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Specimen Status from a string.
		/// </summary>
		/// <param name="specimenStatus"></param>
		/// <returns>enumeration representing Specimen Status</returns>
		public static SpecimenStatus GetSpecimenStatusCodeFromString(string specimenStatus)
		{
			switch( specimenStatus )
			{
				case "A" : return SpecimenStatus.InBloodBank;
				case "C" : return SpecimenStatus.ConvertedFromVista;
				case "N" : return SpecimenStatus.NSR;
				case "R" : return SpecimenStatus.Required;
				default  : return SpecimenStatus.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="780"> 
		///		<ExpectedInput>PatientChangeStatus</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="781"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Static function to return char version of Patient Change Status enum
		/// </summary>
		/// <param name="patientChangeStatus">Patient Change Status enum</param>
		/// <returns>Patient Change Status code</returns>
		public static char GetPatientChangeStatusFromCode(PatientChangeStatus patientChangeStatus)
		{
			switch( patientChangeStatus )
			{
				case PatientChangeStatus.Error					: return 'E';
				case PatientChangeStatus.InProcess				: return 'I';
				case PatientChangeStatus.PendingProcessing		: return 'P';
				case PatientChangeStatus.SuccessfullyProcessed	: return 'S';
				case PatientChangeStatus.Inactive				: return 'X';
				default											: return Char.MinValue;
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4935"> 
		///		<ExpectedInput>PatientChangeStatus</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4936"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of PatientChangeStatus from an enumeration.
		/// </summary>
		/// <param name="patientChangeStatus"></param>
		/// <returns>char representing PatientChangeStatus</returns>
		public static char GetPatientChangeStatusCodeFromEnum(PatientChangeStatus patientChangeStatus)
		{
			switch( patientChangeStatus )
			{
				case PatientChangeStatus.Error					: return 'E';
				case PatientChangeStatus.InProcess				: return 'I';
				case PatientChangeStatus.PendingProcessing		: return 'P';
				case PatientChangeStatus.SuccessfullyProcessed	: return 'S';
				case PatientChangeStatus.Inactive				: return 'X';
				default											: return Char.MinValue;
			}
		}

		///<Developers>
		///	<Developer>COE User</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4937"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>PatientChangeStatus</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4938"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of PatientChangeStatus from a string.
		/// </summary>
		/// <param name="patientChangeStatus"></param>
		/// <returns>enumeration representing PatientChangeStatus</returns>
		public static PatientChangeStatus GetPatientChangeStatusCodeFromString(string patientChangeStatus)
		{
			switch( patientChangeStatus )
			{
				case "E" : return PatientChangeStatus.Error;
				case "I" : return PatientChangeStatus.InProcess;
				case "P" : return PatientChangeStatus.PendingProcessing;
				case "S" : return PatientChangeStatus.SuccessfullyProcessed;
				case "X" : return PatientChangeStatus.Inactive;
				default  : return PatientChangeStatus.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2918"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>ISBTScan</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2919"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of ISBT Scan from a string.
		/// Related to BR_1.20
		/// </summary>
		/// <param name="isbt"></param>
		/// <returns>enumeration representing ISBT Scan</returns>
		public static ISBTScan GetISBTFromString(string isbt)
		{
			if( isbt == null )
				throw( new ArgumentNullException( "isbt" ) );

			if( isbt.Length <= 2 )
				return ISBTScan.Unknown;

			string _isbtFirstTwoChars = isbt.Substring( 0, 2 );
		
			switch( _isbtFirstTwoChars )
			{
				case "=<" : return ISBTScan.ProductCode;
				case "=%" : return ISBTScan.ABORh;
				case "&>" : return ISBTScan.ExpirationDate;
				default   : return isbt.Substring( 0, 1 ).Equals( "=" ) ? ISBTScan.UnitId : ISBTScan.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2920"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2921"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the string representation of Reactivity Phase Text from the Reactivity
		/// Phase Code.
		/// </summary>
		/// <param name="reactivityPhaseCode"></param>
		/// <returns>Reactivity Phase Text</returns>
		public static string GetReactivityPhaseTextFromCode(string reactivityPhaseCode)
		{
			switch( reactivityPhaseCode )
			{
				case "1" : return ReactivityPhase.IS.ToString();
				case "2" : return ReactivityPhase.IAT.ToString();
				case "3" : return ReactivityPhase.ISandIAT.ToString().Replace("and","/");
				case "4" : return ReactivityPhase.ISandRT.ToString().Replace("and","/");
				case "5" : return ReactivityPhase.ISand37.ToString().Replace("and","/");
				case "6" : return ReactivityPhase.AHGandCC.ToString();
				case "7" : return ReactivityPhase.CC.ToString();
				case "8" : return ReactivityPhase.ThreeSevenandAHG.ToString().Replace("Three","3").Replace("Seven","7").Replace("and","/");
				case "9" : return ReactivityPhase.All.ToString();
				default  : return ReactivityPhase.Unknown.ToString();
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="737"> 
		///		<ExpectedInput>CrossmatchResult</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="738"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetCrossmatchResultStringFromEnum
		/// </summary>
		/// <param name="crossmatchResult"></param>
		/// <returns></returns>
		public static string GetCrossmatchResultStringFromEnum(CrossmatchResult crossmatchResult)
		{
			switch( crossmatchResult )
			{
				case CrossmatchResult.CompatibleEXM                      : return "E";
				case CrossmatchResult.IncompatibleDirectorApprovalNeeded : return "G";
				case CrossmatchResult.CompatibleSafeToTransfuse          : return "C";
				case CrossmatchResult.IncompatibleUnsafeToTransfuse      : return "I";
				case CrossmatchResult.CompatibleDontTransfuse            : return "D";
				case CrossmatchResult.Inconclusive						 : return "Z";
				default                                                  : return String.Empty;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="739"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>CrossmatchResult</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="740"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetCrossmatchResultEnumFromString
		/// </summary>
		/// <param name="crossmatchResultText"></param>
		/// <returns></returns>
		public static CrossmatchResult GetCrossmatchResultEnumFromString(string crossmatchResultText)
		{
			switch( crossmatchResultText )
			{
				case "E" : return CrossmatchResult.CompatibleEXM;
				case "G" : return CrossmatchResult.IncompatibleDirectorApprovalNeeded;
				case "C" : return CrossmatchResult.CompatibleSafeToTransfuse;
				case "I" : return CrossmatchResult.IncompatibleUnsafeToTransfuse;
				case "D" : return CrossmatchResult.CompatibleDontTransfuse;
				case "Z" : return CrossmatchResult.Inconclusive;
				default  : return CrossmatchResult.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="742"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>TestResult</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="743"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetTestResultEnumFromString
		/// </summary>
		/// <param name="testResult"></param>
		/// <returns></returns>
		public static TestResult GetTestResultEnumFromString(string testResult)
		{
			switch( testResult.Trim() )
			{
				case "A"  : return TestResult.A;
				case "AB" : return TestResult.AB;
				case "B"  : return TestResult.B;
				case "F"  : return TestResult.F;
				case "H"  : return TestResult.H;
				case "I"  : return TestResult.I;
				case "M"  : return TestResult.M;
				case "N"  : return TestResult.N;
				case "O"  : return TestResult.O;
				case "P"  : return TestResult.P;
				default   : return TestResult.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="747"> 
		///		<ExpectedInput>TestingMethod</ExpectedInput>
		///		<ExpectedOutput>char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="748"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetTestingMethodCodeFromEnum
		/// </summary>
		/// <param name="testingMethod"></param>
		/// <returns></returns>
		public static char GetTestingMethodCodeFromEnum(TestingMethod testingMethod)
		{
			switch(testingMethod)
			{
				case TestingMethod.Gel     : return 'G';
				case TestingMethod.Solid   : return 'S';
				case TestingMethod.Tube    : return 'T';
				case TestingMethod.Unknown : return 'U';
				default                    : return Char.MinValue;
			}
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="750"> 
		///		<ExpectedInput>char</ExpectedInput>
		///		<ExpectedOutput>TestingMethod</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="752"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetTestingMethodEnumFromCode
		/// </summary>
		/// <param name="testingMethod"></param>
		/// <returns></returns>
		public static TestingMethod GetTestingMethodEnumFromCode(char testingMethod)
		{
			switch( testingMethod )
			{
				case 'T' : return TestingMethod.Tube;
				case 'G' : return TestingMethod.Gel;
				case 'S' : return TestingMethod.Solid;
				default  : return TestingMethod.Unknown;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2285"> 
		///		<ExpectedInput>Valid column list and DataTable</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2286"> 
		///		<ExpectedInput>Invalid column list and DataTable</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Verify specified set of columns are in the DataTable provided. 
		/// </summary>
		/// <param name="columnList">List of required columns.</param>
		/// <param name="dt">DataTable to examine</param>
		/// <returns>bool</returns>
		public static bool VerifyMinColumnsInDataTable(string[] columnList,System.Data.DataTable dt)
		{
			foreach(string col in columnList) 
			{
				if(!dt.Columns.Contains(col)) 
				{
					Debug.WriteLine("Missing Column:" + col);
					return false;
				}
			}
			return true;
		}
		


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8359"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8360"> 
		///		<ExpectedInput>Invalid user</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns the number of Vbecs.*exe processes running under the current user id
		/// </summary>
		public static int GetVbecsSessionCount(string ntLoginName)
		{
            //CR3311 - reworked to include admin
			int userCount = 0;      //How many VBECS.*.exe processes belong to me. 

            //Generic with VBECS.%.EXE - should catch VBECS and VBECS Admin also  debugs (VBECS.vshost.exe, etc) 
			System.Management.ObjectQuery oQuery = new System.Management.ObjectQuery("Select * from Win32_Process where name LIKE 'VBECS.%EXE'");
			System.Management.ManagementObjectSearcher oSearcher = new System.Management.ManagementObjectSearcher(oQuery);

			foreach( System.Management.ManagementObject oReturn in oSearcher.Get())
			{
                string[] ownerName = new string[2];
                oReturn.InvokeMethod("GetOwner", (object[])ownerName);

                //If we don't have admin rights on the machine, we won't be able to 
                //actually SEE the owner of processes that don't belong to them - hence, NULL
                if (ownerName[0] == null) continue;

	            if (ownerName[0].ToUpper() == ntLoginName.ToUpper())
	            {
		            userCount++;
	            }
			}

            return (userCount);
		}


		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/5/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1599"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Parsed string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1600"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method parses words with spaces.  Words are designated by capital letters.
		/// </summary>
		/// <param name="startString">string</param>
		/// <returns>string</returns>
		public static string ParseStringwithSpaces(string startString)
		{
			try
			{
				System.Text.StringBuilder sb = new System.Text.StringBuilder();
				//
				for (int i = 0; i < startString.Length; i++)
				{
					//don't put space before 1st char
					if ((i>0)&&(char.IsUpper(startString[i])))
					{
						sb.Append(" ");
					}
					sb.Append(startString[i]);
				}
				return sb.ToString();
			}

			catch
			{
				return startString;
			}
		}

		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2289"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Parsed string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2290"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method parses words with spaces.  Words are designated by capital letters.
		/// </summary>
		/// <param name="startString"></param>
		/// <param name="deleteSet"></param>
		/// <returns></returns>
		public static string ParseStringwithSpaces(string startString, bool deleteSet)
		{
			try
			{
				System.Text.StringBuilder sb = new System.Text.StringBuilder();

				for (int i = 0; i < startString.Length; i++)
				{
					if (char.IsUpper(startString[i]) && (i < startString.Length - 1) && char.IsLower(startString[i + 1]))
					{
						sb.Append(" ");
					}
					sb.Append(startString[i]);

				}
				
				//Append space at the end as well
				sb.Append(" ");

				if (deleteSet)
				{
					return sb.ToString().Substring(sb.ToString().IndexOf("_") + 1);
				}
				else
				{
					return sb.ToString();
				}
			}
			catch
			{
				return startString;
			}
		}
		
		[DllImport("user32.dll")]
		private static extern void MessageBeep(uint n);        

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="753"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="755"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// MessageBeep
		/// </summary>
		public static void MessageBeep()
		{
			MessageBeep( 0x0 );
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2961"> 
		///		<ExpectedInput>Set of strings</ExpectedInput>
		///		<ExpectedOutput>Concatenated string with newlines between messages</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2962"> 
		///		<ExpectedInput>Set of strings and null</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		///	Concatenates arbitrary number of strings putting a newline characters 
		///	between strings. Empty (and spaces-only) strings are skipped, nulls will 
		///	cause ArgumentNullException.
		///	Used to sum up broken rules validation messages and set the result as a tool tip. 
		///	If all the source strings are empty (or filled with blanks) it will 
		///	return String.Empty
		///</summary>
		///<param name="brokenRulesMessages">Arbitrary number of strings</param>
		///<returns>Concatenated strings separated with newline characters</returns>
		public static string SumBrokenRulesMessages( params string[] brokenRulesMessages )
		{
			System.Text.StringBuilder sb = new System.Text.StringBuilder();
			bool isFirstItemSet = false;

			if( brokenRulesMessages == null )
				throw( new ArgumentNullException( "brokenRulesMessages" ) );
	
			foreach( string msg in brokenRulesMessages )
			{
				if( msg == null )
					throw( new ArgumentNullException( "brokenRulesMessages" ) );

				string buf = msg.Trim();

				if( buf != String.Empty )
				{
					if( !isFirstItemSet )	
						isFirstItemSet = true;
					else
						sb.Append( Environment.NewLine );
				
					sb.Append( buf );
				}
			}

			return isFirstItemSet ? sb.ToString() : String.Empty;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="768"> 
		///		<ExpectedInput>data table, UpdateFunction</ExpectedInput>
		///		<ExpectedOutput>data table with LastUpdateFunctionId column appended to it</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="773"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Appends the LastUpdateFunctionID column if needed to the table and fills in all values
		/// </summary>
		/// <param name="dtInput"></param>
		/// <param name="lastUpdateFunctionId"></param>
		/// <returns></returns>
		public static DataTable AppendLastUpdateInformation( DataTable dtInput, UpdateFunction lastUpdateFunctionId )
		{
			if( dtInput == null )
				return null;

			if( !dtInput.Columns.Contains( VbecsTables.BloodUnit.LastUpdateFunctionId ) )
				dtInput.Columns.Add( VbecsTables.BloodUnit.LastUpdateFunctionId, typeof(int) );

			foreach( DataRow dr in dtInput.Rows )
				dr[VbecsTables.BloodUnit.LastUpdateFunctionId] = (int)lastUpdateFunctionId;

			return dtInput;
		}


		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3648"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>OrderAlertTypeCode</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3649"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetOrderAlertTypeTypeFromString
		/// </summary>
		/// <param name="orderAlertString"></param>
		/// <returns></returns>
		public static OrderAlertTypeCode GetOrderAlertTypeTypeFromString(string orderAlertString)
		{
			switch( orderAlertString )
			{
				case "A" : return OrderAlertTypeCode.All_orders;
				case "H" : return OrderAlertTypeCode.Hour_limit;
				case "S" : return OrderAlertTypeCode.Specimen_OK_or_NA;
				default  : return OrderAlertTypeCode.Unknown;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3650"> 
		///		<ExpectedInput>OrderAlertTypeCode</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3651"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetOrderAlertTypeTypeFromEnum
		/// </summary>
		/// <param name="orderAlertEnum"></param>
		/// <returns></returns>
		public static string GetOrderAlertTypeTypeFromEnum(OrderAlertTypeCode orderAlertEnum)
		{
			switch( orderAlertEnum )
			{
				case OrderAlertTypeCode.All_orders        : return "A";
				case OrderAlertTypeCode.Hour_limit        : return "H";
				case OrderAlertTypeCode.Specimen_OK_or_NA : return "S";
				default                                   : return null;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="774"> 
		///		<ExpectedInput>CrossmatchResult</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="775"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetCautionTagCrossmatchText
		/// </summary>
		/// <param name="xmResult"></param>
		/// <returns></returns>
		public static string GetCautionTagCrossmatchText(CrossmatchResult xmResult)
		{
			switch( xmResult )
			{
				case CrossmatchResult.CompatibleSafeToTransfuse          :
				case CrossmatchResult.CompatibleEXM                      : return StrRes.OtherMsg.UC043.Compatible().ResString;;
				case CrossmatchResult.IncompatibleDirectorApprovalNeeded : return StrRes.OtherMsg.UC043.MedicalDirectorApprovalOnly().ResString;
				default                                                  : return StrRes.OtherMsg.UC043.NoCrossmatchAtIssue().ResString;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="776"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>ABO</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="777"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetAboFromString
		/// </summary>
		/// <param name="aboString"></param>
		/// <returns></returns>
		public static ABO GetAboFromString(string aboString)
		{
			switch( aboString.Trim().ToUpper() )
			{
				case "A"  : return ABO.A;
				case "B"  : return ABO.B;
				case "AB" : return ABO.AB;
				case "O"  : return ABO.O;
				case "I"  : return ABO.I;
				case "MX" : return ABO.Mx;
				default   : return ABO.NA;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5029"> 
		///		<ExpectedInput>ABO</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5030"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetAboFromEnum
		/// </summary>
		/// <param name="abo"></param>
		/// <returns></returns>
		public static string GetAboFromEnum(ABO abo)
		{
			switch( abo )
			{
				case ABO.A  : return "A";
				case ABO.B  : return "B";
				case ABO.AB : return "AB";
				case ABO.O  : return "O";
				case ABO.I  : return "I";
				case ABO.Mx : return "Mx";
				default     : return "NA";
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="778"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>RH</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="779"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetRhFromString
		/// </summary>
		/// <param name="rhString"></param>
		/// <returns></returns>
		public static RH GetRhFromString(string rhString)
		{
			switch( rhString.ToUpper().Trim() )
			{
				case "P" : return RH.Positive;
				case "N" : return RH.Negative;
				case "I" : return RH.Inconclusive;
				case " " :
				case "Z" : return RH.Blank;
				case "Y" : return RH.PooledRH;
				default  : return RH.NotProvided;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5031"> 
		///		<ExpectedInput>RH</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5032"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetRhFromEnum
		/// </summary>
		/// <param name="rh"></param>
		/// <returns></returns>
		public static string GetRhFromEnum(RH rh)
		{
			switch( rh )
			{
				case RH.Positive     : return "P";
				case RH.Negative     : return "N";
				case RH.Inconclusive : return "I";
				case RH.Blank        : return String.Empty;
				case RH.PooledRH     : return "Y";
				default              : return "NA";
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4404"> 
		///		<ExpectedInput>Valid DataRow and list of columns.</ExpectedInput>
		///		<ExpectedOutput>None.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4405"> 
		///		<ExpectedInput>Valid DataRow and column name that is not DataRow.</ExpectedInput>
		///		<ExpectedOutput>ArgumentException.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4406"> 
		///		<ExpectedInput>Valid DataRow and no columns.</ExpectedInput>
		///		<ExpectedOutput>None.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4407"> 
		///		<ExpectedInput>Null as DataRow.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4408"> 
		///		<ExpectedInput>Valid DataRow and list of column names with null among them.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Asserts that specified columns present in the supplied <see cref="DataRow"/>. 
		/// Throws <see cref="ArgumentException"/> otherwise. 
		/// </summary>
		/// <param name="dtRow"><see cref="DataRow"/> to validate. Can not be null.</param>
		/// <param name="columnNames">Column names to validate against. Can not contain null names.</param>
		public static void RequireColumns( DataRow dtRow, params string[] columnNames )
		{
			if( dtRow == null )
				throw( new ArgumentNullException( "dtRow" ) );

			foreach( string _columnName in columnNames )
			{
				if( _columnName == null )
					throw( new ArgumentNullException( "columnNames" ) );

				if( !dtRow.Table.Columns.Contains( _columnName ) )
					throw( new ArgumentException( StrRes.SysErrMsg.Common.ColumnNotFoundInDataRow( _columnName ).ResString ) );
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/7/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4658"> 
		///		<ExpectedInput>Valid DataRow and list of columns.</ExpectedInput>
		///		<ExpectedOutput>None.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4659"> 
		///		<ExpectedInput>DataRow containing null values and valid list of columns.</ExpectedInput>
		///		<ExpectedOutput>ArgumentException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Asserts that specified columns are in the supplied <see cref="DataRow"/> and
		/// they contain non-null values. Throws <see cref="ArgumentException"/> otherwise.
		/// </summary>
		/// <param name="dtRow"><see cref="DataRow"/> to validate. Can not be null.</param>
		/// <param name="columnNames">Column names to validate against. Can not contain null names.</param>
		public static void RequireNonNullColumns( DataRow dtRow, params string[] columnNames )
		{
			RequireColumns( dtRow, columnNames );

			foreach( string _columnName in columnNames )
				if( dtRow.IsNull( _columnName ) )
					throw( new ArgumentException( StrRes.SysErrMsg.Common.UnexpectedNullValueFoundInDataRow( _columnName ).ResString ) );
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8240"> 
		///		<ExpectedInput>Valid DataTable and list of columns.</ExpectedInput>
		///		<ExpectedOutput>None.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8241"> 
		///		<ExpectedInput>DataTable containing null values and valid list of columns.</ExpectedInput>
		///		<ExpectedOutput>ArgumentException.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Asserts that specified columns are in the supplied <see cref="DataTable"/> and
		/// they contain non-null values. Throws <see cref="ArgumentException"/> otherwise.
		/// </summary>
		/// <param name="dataTable"><see cref="DataTable"/> to validate. Can not be null.</param>
		/// <param name="columnNames">Column names to validate against. Can not contain null names.</param>
		public static void RequireNonNullColumns( DataTable dataTable, params string[] columnNames )
		{
			// TODO: Consider throwing exception if the data table has no rows. Currently it passes.
			for (int rowIndex = 0; rowIndex < dataTable.Rows.Count; rowIndex++)
			{
				RequireColumns( dataTable.Rows[rowIndex], columnNames );

				for (int colIndex = 0; colIndex < columnNames.Length; colIndex++)
				{
					if(	dataTable.Rows[rowIndex].IsNull( columnNames[colIndex]) )
					{
						throw( new ArgumentException( StrRes.SysErrMsg.Common.UnexpectedNullValueFoundInDataRow( columnNames[colIndex] ).ResString ) );
					}

				}
			}
		}

		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/27/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5598"> 
		///		<ExpectedInput>Call to 2 methods, first returns false, second - true.</ExpectedInput>
		///		<ExpectedOutput>False and both methods are called.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5599"> 
		///		<ExpectedInput>No parameters.</ExpectedInput>
		///		<ExpectedOutput>True.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5600"> 
		///		<ExpectedInput>Method cannot fail.</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Helper method returning logical sum of all supplied parameters. 
		/// Differs from conventional a &amp; by forcing evaluation of all parameters
		/// even if preceding are false. 
		/// 
		/// May be used to summarize validation results on a UI forms.
		/// </summary>
		/// <param name="valuesToCheck">List of parameters to be evaluated and logically added.</param>
		/// <returns>Logic sum of all supplied parameters.</returns>
		public static bool ForcedCheckLogicAnd( params bool[] valuesToCheck )
		{
			bool _result = true;

			foreach( bool _vl in valuesToCheck )
				_result = _result && _vl;

			return _result;			
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5942"> 
		///		<ExpectedInput>Active record status code - 'A'.</ExpectedInput>
		///		<ExpectedOutput>True.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5943"> 
		///		<ExpectedInput>Inactive record status code - 'X'.</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5946"> 
		///		<ExpectedInput>Null</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5947"> 
		///		<ExpectedInput>System.DbNull.Value.</ExpectedInput>
		///		<ExpectedOutput>ArgumentOutOfRangeException.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Checks if supplied record status code object (char retrieved from the DB) is active. 
		/// Will throw an exception if given null/dbnull.
		/// </summary>
		/// <param name="recordStatusCode">Record status code char.</param>
		/// <returns>True if supplied record status code is 'active'.</returns>
		public static bool GetIsActiveStatusByStatusCode( object recordStatusCode )
		{
			if( recordStatusCode == null )
				throw( new ArgumentNullException( "recordStatusCode" ) );

			if( recordStatusCode == DBNull.Value )
				throw( new ArgumentOutOfRangeException( "recordStatusCode", StrRes.SysErrMsg.Database.DbNullCantBeConvertedToBoolean().ResString ) );

			return GetRecordStatusCodeFromString( recordStatusCode.ToString() ) == RecordStatusCode.Active;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5944"> 
		///		<ExpectedInput>True.</ExpectedInput>
		///		<ExpectedOutput>'A' - corresponding to RecordStatusCode.Active.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5945"> 
		///		<ExpectedInput>False.</ExpectedInput>
		///		<ExpectedOutput>'X' - corresponding to RecordStatusCode.Inactive.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets active/inactive record status code char depending on the supplied parameter.
		/// </summary>
		/// <param name="isActive">Is active status code needed.</param>
		/// <returns>Active record status code char if supplied parameter is boolean, otherwise - false.</returns>
		public static char GetRecordStatusCodeCharFromBoolean( bool isActive )
		{
			return GetRecordStatusCodeCharFromEnum( isActive ? RecordStatusCode.Active : RecordStatusCode.Inactive );
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8232"> 
		///		<ExpectedInput>Enum</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8233"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to return int value of AdditionalBloodUnitSearchCriteriaValueFromEnum
		/// </summary>
		/// <param name="additionalBloodUnitSearchCriteria">AdditionalBloodUnitSearchCriteria enum</param>
		/// <returns>Patient Change Status code</returns>
		public static int GetAdditionalBloodUnitSearchCriteriaValueFromEnum (AdditionalBloodUnitSearchCriteria additionalBloodUnitSearchCriteria)
		{
			switch( additionalBloodUnitSearchCriteria )
			{
				case AdditionalBloodUnitSearchCriteria.None 				: return 0;
				case AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus	: return 1;
				case AdditionalBloodUnitSearchCriteria.InactiveUnits		: return 2;
				default														: return -1;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8234"> 
		///		<ExpectedInput>Valid Abo Parameters</ExpectedInput>
		///		<ExpectedOutput>String</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8235"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InterpretAbo
		/// </summary>
		/// <param name="AntiA"></param>
		/// <param name="AntiB"></param>
		/// <param name="AntiAB"></param>
		/// <param name="A1Cell"></param>
		/// <param name="BCell"></param>
		/// <returns></returns>
		public static string InterpretAbo(string AntiA, string AntiB, string AntiAB, string A1Cell, string BCell)
		{
			Hashtable resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add("", "X");
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");

			if (resultLookup[AntiA].ToString() == "N" &&
				resultLookup[AntiB].ToString() == "N" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "N") &&
				resultLookup[A1Cell].ToString() == "P" &&
				resultLookup[BCell].ToString() == "P")
			{
				return "O";
			}
			else if (resultLookup[AntiA].ToString() == "P" &&
				resultLookup[AntiB].ToString() == "N" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "P") &&
				resultLookup[A1Cell].ToString() == "N" &&
				resultLookup[BCell].ToString() == "P")
			{
				return "A";
			}
			else if (resultLookup[AntiA].ToString() == "N" &&
				resultLookup[AntiB].ToString() == "P" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "P") &&
				resultLookup[A1Cell].ToString() == "P" &&
				resultLookup[BCell].ToString() == "N")
			{
				return "B";
			}
			else if (resultLookup[AntiA].ToString() == "P" &&
				resultLookup[AntiB].ToString() == "P" &&
				(resultLookup[AntiAB].ToString() == "X" || resultLookup[AntiAB].ToString() == "P") &&
				resultLookup[A1Cell].ToString() == "N" &&
				resultLookup[BCell].ToString() == "N")
			{
				return "AB";
			}
			else
			{
				return "I";
			}
		}

		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8236"> 
		///		<ExpectedInput>Valid RH Parameters</ExpectedInput>
		///		<ExpectedOutput>String</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8237"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InterpretRh
		/// </summary>
		/// <param name="AntiD"></param>
		/// <param name="DControl"></param>
		/// <returns></returns>
		public static string InterpretRh(string AntiD, string DControl)
		{
			Hashtable resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add("", "X");
			resultLookup.Add("X", "X");
				
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");

			
			if (resultLookup[AntiD].ToString() == "P" &&
				(resultLookup[DControl].ToString() == "X" || resultLookup[DControl].ToString() == "N"))
			{
				return "P";
			}
			else if (resultLookup[AntiD].ToString() == "N" &&
				(resultLookup[DControl].ToString() == "X" || resultLookup[DControl].ToString() == "N"))
			{
				return "N";
			}
			else
			{
				return "I";
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/30/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8238"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>ExceptionReportType</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8239"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of Exception Report Type from a string.
		/// </summary>
		/// <param name="exceptionReportType"></param>
		/// <returns>Enumeration representing Exception Report Type</returns>
		public static ExceptionReportType GetExceptionReportTypeFromString(string exceptionReportType)
		{
			switch( exceptionReportType )
			{
				case "ExceptionReportAboIncompatibleTransfusion" : return ExceptionReportType.ExceptionReportAboIncompatibleTransfusion;
				case "ExceptionReportAntigenTest" : return ExceptionReportType.ExceptionReportAntigenTest;
				case "ExceptionReportCautionTagBTRFPrinting" : return ExceptionReportType.ExceptionReportCautionTagBTRFPrinting;
				case "ExceptionReportExpiredTaskProcessed" : return ExceptionReportType.ExceptionReportExpiredTaskProcessed;
				case "ExceptionReportExpiredUnit" : return ExceptionReportType.ExceptionReportExpiredUnitReceived;
				case "ExceptionReportLabelMismatch" : return ExceptionReportType.ExceptionReportLabelMismatch;
				case "ExceptionReportMain" : return ExceptionReportType.ExceptionReportMain;
				case "ExceptionReportPatientAboRH" : return ExceptionReportType.ExceptionReportPatientAboRh;
				case "ExceptionReportPatientAboRHDiscrepancy" : return ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy;
				case "ExceptionReportPatientAntigenDiscrepancy" : return ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy;
				case "ExceptionReportPatientRestriction" : return ExceptionReportType.ExceptionReportPatientRestriction;
				case "ExceptionReportPatientTest" : return ExceptionReportType.ExceptionReportPatientTest;
				case "ExceptionReportPatientTestInactivated" : return ExceptionReportType.ExceptionReportPatientTestInactivated;
				case "ExceptionReportQC" : return ExceptionReportType.ExceptionReportQC;
				case "ExceptionReportQCInactivated" : return ExceptionReportType.ExceptionReportQCInactivated;
				case "ExceptionReportQCNotPerformed" : return ExceptionReportType.ExceptionReportQCNotPerformed;
				case "ExceptionReportQuarantine" : return ExceptionReportType.ExceptionReportQuarantine;
				case "ExceptionReportReflexTest" : return ExceptionReportType.ExceptionReportReflexTest;
				case "ExceptionReportReturnIssuedUnit" : return ExceptionReportType.ExceptionReportReturnIssuedUnit;
				case "ExceptionReportSpecimen" : return ExceptionReportType.ExceptionReportSpecimen;
				case "ExceptionReportTransfusion" : return ExceptionReportType.ExceptionReportTransfusion;
				case "ExceptionReportTransfusionReactionWorkup" : return ExceptionReportType.ExceptionReportTransfusionReactionWorkup;
				case "ExceptionReportTrwSpecimen" : return ExceptionReportType.ExceptionReportTrwSpecimen;
				case "ExceptionReportUnitAboRH" : return ExceptionReportType.ExceptionReportUnitAboRh;
				case "ExceptionReportUnitERIssuedTestingProblem" : return ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem;
				case "ExceptionReportUnitIssue" : return ExceptionReportType.ExceptionReportUnitIssue;
				case "ExceptionReportUnitModification" : return ExceptionReportType.ExceptionReportUnitModification;
				case "ExceptionReportUnitSelection" : return ExceptionReportType.ExceptionReportUnitSelection;
				case "ExceptionReportUnitSupply" : return ExceptionReportType.ExceptionReportUnitSupply;
				case "ExceptionReportUnitTest" : return ExceptionReportType.ExceptionReportUnitTest;
				case "ExceptionReportEmergencyIssueOrder" : return ExceptionReportType.ExceptionReportEmergencyIssueOrder;
				case "ExceptionReportExpiredOrder" : return ExceptionReportType.ExceptionReportExpiredTaskProcessed;
				case "ExceptionReportRemoveFinalUnitStatus" : return ExceptionReportType.ExceptionReportRemoveFinalUnitStatus;
				case "ExceptionReportCrossmatch" : return ExceptionReportType.ExceptionReportCrossmatch;
				//CR 2942
				case "ExceptionReportElectronicTransfusion" : return ExceptionReportType.ExceptionReportElectronicTransfusion;
				default  : return ExceptionReportType.Unknown;
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8168"> 
		///		<ExpectedInput>Valid DonationTypeId</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8169"> 
		///		<ExpectedInput>Invalid DonationTypeId</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// IsRestricted
		/// Implements PT_1.05
		/// </summary>
		/// <param name="donationTypeID"></param>
		/// <returns>True/False</returns>
		public static bool IsRestricted(int donationTypeID)
		{
			// Most types are restricted (autologous or directed);  
			// it's easiest just to check the other cases
			// donationTypeID = 1, 2, and 17
			return ( donationTypeID != 1 && donationTypeID != 2 && donationTypeID != 17 );
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8252"> 
		///		<ExpectedInput>directed int</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8253"> 
		///		<ExpectedInput>non-directed int</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// IsDirected
		/// </summary>
		/// <param name="donationTypeID"></param>
		/// <returns></returns>
		public static bool IsDirected(int donationTypeID)
		{
			// directed units -> donationTypeID = 3-8, 12-16, 18-20
			if(donationTypeID == 3 || donationTypeID == 4  || donationTypeID == 5
				|| donationTypeID == 6  || donationTypeID == 7  || donationTypeID == 8
				|| donationTypeID == 12  || donationTypeID == 13  || donationTypeID == 14
				|| donationTypeID == 15  || donationTypeID == 16  || donationTypeID == 18  
				|| donationTypeID == 19  || donationTypeID ==20)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8254"> 
		///		<ExpectedInput>autologous int</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8255"> 
		///		<ExpectedInput>non-autologous int</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// IsAutologous
		/// </summary>
		/// <param name="donationTypeID"></param>
		/// <returns></returns>
		public static bool IsAutologous(int donationTypeID)
		{
			// suggest to replace it with: return ( donationTypeID == 9 || donationTypeID == 10  || donationTypeID == 11 );

			// autologous units -> donationTypeID = 9, 10, 11
			if (donationTypeID == 9 || donationTypeID == 10  || donationTypeID == 11)
			{
				return true;
			}
			else
			{
				return false;
			}

		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8256"> 
		///		<ExpectedInput>exception object</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8257"> 
		///		<ExpectedInput>Invalid exception</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Checks if the supplied exception is caused by SQL Server connectivity error. 
		/// </summary>
		/// <param name="exceptionObject">Exception to check.</param>
		/// <returns>True if supplied exception is caused by SQL Server connectivity error.</returns>
		public static bool IsDbConnectivityError( object exceptionObject )
		{
			SqlException sqlXcp = exceptionObject as SqlException;

			if( sqlXcp == null || sqlXcp.Errors[0] == null )
				return false;

			int _dbErrorNumber = sqlXcp.Errors[0].Number;

			return _dbErrorNumber == 11 || _dbErrorNumber == 17 || _dbErrorNumber == 18452 || _dbErrorNumber == -2 || sqlXcp.Errors[0].Class >= 20;
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8258"> 
		///		<ExpectedInput>exception</ExpectedInput>
		///		<ExpectedOutput>StringResourceItem</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8259"> 
		///		<ExpectedInput>Invalid exception object</ExpectedInput>
		///		<ExpectedOutput>DbConnectivityFailureGeneral</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Forms user-oriented error message from the supplied exception object. 
		/// </summary>
		/// <param name="exceptionObject">DB connectivity exception object.</param>
		/// <returns>User-oriented error message.</returns>
		public static StrRes.StringResourceItem FormErrorMessageBasedOnDbConnectivityErrorObject( object exceptionObject )
		{
			SqlException sqlXcp = exceptionObject as SqlException;

			if( sqlXcp == null || sqlXcp.Message == null || sqlXcp.Message.Length == 0 )
				return StrRes.SysErrMsg.Database.DbConnectivityFailureGeneral();

			// TODO: Move string to resources (file is currently held by Darlene).
			if( sqlXcp.Errors.Count > 0 && sqlXcp.Number == -2 )
				return new StrRes.StringResourceItem( "Database did not respond for a long period of time while executing the query and it led to command timeout error. This is most likely caused by heavy load on the VBECS application server. Please contact your system administrator.", StringResourceType.SystemError );

			return StrRes.SysErrMsg.Database.DbConnectivityFailureDescribed( sqlXcp.Message );
		}

		/// <summary>
		/// This method sets a registry value that enables the default beep for the user.
		/// 8/26/2011: Added Exclamation, Program error and System notification beeps. This
		/// addresses the following CRs: 1893, 2014, 2017, 2019, 2033, 2038, 2045, 2115, 2193, 
		/// 2195, 2199
		/// </summary>
		public static void EnableSound()
		{
			RegistryKey parentyKey = Registry.CurrentUser;

			// Default beep
			RegistryKey key = parentyKey.OpenSubKey( @"AppEvents\Schemes\Apps\.Default\.Default\.Current\", true);
			key.SetValue(string.Empty, @"c:\Windows\media\Windows Critical Stop.wav");


			// Exclamation
			key = parentyKey.OpenSubKey( @"AppEvents\Schemes\Apps\.Default\SystemExclamation\.Current\", true);
            key.SetValue(string.Empty, @"c:\Windows\media\Windows Critical Stop.wav");
	
			
			// Program error
			key = parentyKey.OpenSubKey( @"AppEvents\Schemes\Apps\.Default\AppGPFault\.Current\", true);
            key.SetValue(string.Empty, @"c:\Windows\media\Windows Critical Stop.wav");


			// Critical Stop/System Hand (in registy)
			key = parentyKey.OpenSubKey( @"AppEvents\Schemes\Apps\.Default\SystemHand\.Current\", true);
            key.SetValue(string.Empty, @"c:\Windows\media\Windows Critical Stop.wav");

			
			// System Notification
			key = parentyKey.OpenSubKey( @"AppEvents\Schemes\Apps\.Default\SystemNotification\.Current\", true);
            key.SetValue(string.Empty, @"c:\Windows\media\Windows Critical Stop.wav");
		}

		///<Developers>
		///	<Developer>VHA</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/23/2007</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8510"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8511"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns all printers that are installed on the server. CR 2320
		/// </summary>
		/// <returns></returns>
		public static Array GetPrintersInstalledOnServer()
		{
			int printerCount = System.Drawing.Printing.PrinterSettings.InstalledPrinters.Count;
			string [] printers = new string[printerCount];
			for (int i=0; i<printerCount; i++)
			{
				printers[i] = (string) System.Drawing.Printing.PrinterSettings.InstalledPrinters[i];
			}
			return printers;
		}

		/// <summary>
		/// Gets the ReactivityPhaseCode from character
		/// CR 2717
		/// </summary>
		/// <param name="reactivityChar"></param>
		/// <returns></returns>
		public static Common.ReactivityPhase GetReactivityPhaseCodeFromChar(char reactivityChar)
		{
			switch(reactivityChar)
			{
				case '1' : return Common.ReactivityPhase.IS;
				case '2' : return Common.ReactivityPhase.IAT;
				case '3' : return Common.ReactivityPhase.ISandIAT;
				case '4' : return Common.ReactivityPhase.ISandRT;
				case '5' : return Common.ReactivityPhase.ISand37;
				case '6' : return Common.ReactivityPhase.AHGandCC;
				case '7' : return Common.ReactivityPhase.CC;
				case '8' : return Common.ReactivityPhase.ThreeSevenandAHG;
				case '9' : return Common.ReactivityPhase.All;
				default : return Common.ReactivityPhase.Unknown;
			}
		}

		/// <summary>
		/// Gets the ReactivityPhase character from code
		/// CR 2717
		/// </summary>
		/// <param name="reactivityPhaseCode"></param>
		/// <returns></returns>
		public static char GetReactivityCharFromCode(Common.ReactivityPhase reactivityPhaseCode)
		{
			switch(reactivityPhaseCode)
			{
				case Common.ReactivityPhase.IS : return '1';
				case Common.ReactivityPhase.IAT: return '2';
				case Common.ReactivityPhase.ISandIAT : return '3';
				case Common.ReactivityPhase.ISandRT : return '4';
				case Common.ReactivityPhase.ISand37 : return '5';
				case Common.ReactivityPhase.AHGandCC : return '6';
				case Common.ReactivityPhase.CC : return '7';
				case Common.ReactivityPhase.ThreeSevenandAHG : return '8';
				case Common.ReactivityPhase.All : return '9';
				default : return ' ';
			}
		}

		/// <summary>
		/// Computer speaks text that is sent
		/// </summary>
		public static void Speak(string sText)
		{			
			try
			{
				if ( Common.LogonUser.IsVisuallyImpairedUser )
				{
					StringBuilder sTextToSpeak = new StringBuilder();

					// Split the incoming text into an array, using the various word separators as delimiters
					string [] s = sText.Split( new char[] { ' ', ',', '.', ';', '?', '\n', '/', '\r' });
			
					if (speakTextResultLookup.Count == 0)
					{
						// Words & terms that don't sound correct & need some help
						speakTextResultLookup.Add("VBECS", "V bex");
						speakTextResultLookup.Add("Anti-K", "Anti big K");
						speakTextResultLookup.Add("Anti-k", "Anti small k");
						speakTextResultLookup.Add("Abo", "A B O ");
						speakTextResultLookup.Add("ABO", "A B O ");
						speakTextResultLookup.Add("Rh", "R H ");
						speakTextResultLookup.Add("ABORH", "A B O R H ");
						speakTextResultLookup.Add("ID", "I D");
						speakTextResultLookup.Add("id", "I D");
						speakTextResultLookup.Add("Id", "I D");
						speakTextResultLookup.Add("iD", "I D");
						speakTextResultLookup.Add("unit(s)", "units");
						speakTextResultLookup.Add("Hcpcs", "H C P C S");
						speakTextResultLookup.Add("BloodUnit", "Blood Unit");
						speakTextResultLookup.Add("CET", "Central European");
						speakTextResultLookup.Add("EET", "Eastern European");
						speakTextResultLookup.Add("AST", "Atlantic Standard");
						speakTextResultLookup.Add("EST", "Eastern Standard");
						speakTextResultLookup.Add("CST", "Central Standard");
						speakTextResultLookup.Add("MST", "Mountain Standard");
						speakTextResultLookup.Add("PST", "Pacific Standard");
						speakTextResultLookup.Add("YST", "Yukon Standard");
						speakTextResultLookup.Add("HAST", "Hawaii-Aleutian Standard");
						speakTextResultLookup.Add("WST", "West Samoa");
						speakTextResultLookup.Add("IDL", "International Date Line");
						speakTextResultLookup.Add("UTC", "Universal Coordinated");


						speakTextResultLookup.Add("CRYOPRECIPITATE", "cryo pre sippi tayt"); // case matters here

						// Words that I just don't like how they're pronounced
						speakTextResultLookup.Add("Unsaved", "Unsayved");
					}

					for (int i = 0; i < s.Length; i++)
					{
						if (speakTextResultLookup.Contains(s[i])) 
						{
							// It's one of them special words or terms that must be handled separately by using the hash table to look up a new pronounciation
							sTextToSpeak.Append(speakTextResultLookup[s[i]] + " ");
						}
						else if(Common.RegularExpressions.SsnNoDashes().IsMatch(s[i]) || 
							Common.RegularExpressions.PatientSsn().IsMatch(s[i]) || 
							Common.RegularExpressions.ISBT128UnitID().IsMatch(s[i]) || 
							Common.RegularExpressions.ScannedISBT128UnitID().IsMatch(s[i]) ||
							Common.RegularExpressions.CodabarUnitID().IsMatch(s[i]) ||
							Common.RegularExpressions.ScannedCodabarUnitID().IsMatch(s[i]) ||
							Common.RegularExpressions.ISBT128ProductCode().IsMatch(s[i]) || 
							Common.RegularExpressions.CodabarProductCode().IsMatch(s[i]))
						{
							// It matches a regular expression for a unit id, product code, or ssn.  Speak each character.
							for(int nCtr = 0; nCtr < s[i].Length; nCtr++)
							{
								sTextToSpeak.Append(s[i][nCtr]);
								sTextToSpeak.Append(" ");
							}
							// put a pause at the end for good measure
							sTextToSpeak.Append(", ");
						}
						else
						{
							// It's nothing special, so speak it as is
							sTextToSpeak.Append(s[i]);
							sTextToSpeak.Append(" ");
						}
					}
					//CR 2930
//					SpVoice objSpeech = new SpVoice();
//					objSpeech.Speak(sTextToSpeak.ToString(), SpeechVoiceSpeakFlags.SVSFDefault);
//					objSpeech = null;
				}
			}
			catch
			{
				
			}
		}

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/16/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9174"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9175"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Computer speaks text that is sent
		/// </summary>
		public static void SpeakAbbreviations(string sText)
		{
			for(int nCtr = 0; nCtr < sText.Length; nCtr++)
			{
				Common.Utility.Speak(sText.Substring(nCtr, 1));
			}
		}

		///<Developers>
		///	<Developer>Department of Veterans Affairs</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/17/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9190"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9191"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the string representing HL7BPDispenseStatus from an enumeration.
		/// CR 2959
		/// </summary>
		/// <param name="dispenseStatus"><see cref="HL7BPDispenseStatus"/></param>
		/// <returns>string</returns>
		public static string GetHL7BPDispenseStatusStringFromEnum(HL7BPDispenseStatus dispenseStatus)
		{
			switch (dispenseStatus)
			{
				case(HL7BPDispenseStatus.DS):	// Dispensed to patient location 
					return "DS";
				case(HL7BPDispenseStatus.RE):	// Released - no longer allocated to patient
					return "RE";
				case(HL7BPDispenseStatus.RS):	// Reserved - ordered and product allocated for patient
					return "RS";
				default:						// Unknown
					return "UK";				
			}
		}

        ///<Developers>
        ///	<Developer>Department of Veterans Affairs</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>1/15/2013</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="9190"> 
        ///		<ExpectedInput>Valid</ExpectedInput>
        ///		<ExpectedOutput></ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="9191"> 
        ///		<ExpectedInput>Invalid</ExpectedInput>
        ///		<ExpectedOutput></ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// This gets a string representation of the enum
        /// </summary>
        /// <param name="appName"><see cref="ApplicationNameGlobalConfig"/></param>
        /// <returns>string</returns>
        public static string GetApplicationNameGlobalConfigStringFromEnum(ApplicationNameGlobalConfig appName)
        {
            switch (appName)
            {
                case (ApplicationNameGlobalConfig.HL7Client):
                    return "HL7Client";
                case (ApplicationNameGlobalConfig.HL7Service):	
                    return "HL7Service";
                case (ApplicationNameGlobalConfig.ReportScheduler):
                    return "ReportScheduler";
                case (ApplicationNameGlobalConfig.Vbecs):
                    return "Vbecs";
                case (ApplicationNameGlobalConfig.VbecsAdmin):
                    return "VbecsAdmin";
                case (ApplicationNameGlobalConfig.VistalinkListener):
                    return "VistalinkListener";
                case (ApplicationNameGlobalConfig.VistaLinkService): // CR 3419
                    return "VistalinkService";
                default:						// Unknown
                    return "UnKnown";
            }
        }

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/16/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9172"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9173"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Return Application Record Type as int
		/// </summary>
		public static int GetApplicationOfRecordTypeIntegerValue( ApplicationOfRecordType applicationOfRecordType )
		{
			return Convert.ToInt32( applicationOfRecordType );
		}

        ///<Developers>
        ///	<Developer>Carl Jensen</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/16/2014</CreationDate>
        ///
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Restarts VBECS services.
        /// </summary>
        public static bool RestartService(bool isProd, Common.ApplicationNameGlobalConfig serv)
        {
            string serviceName = string.Empty;

            if (isProd)
            {
                switch (serv)
                {
                    case Common.ApplicationNameGlobalConfig.HL7Service:
                        serviceName = ProdHL7Service;
                        break;
                    case Common.ApplicationNameGlobalConfig.VistaLinkService:
                        serviceName = ProdVistaService;
                        break;
                    case Common.ApplicationNameGlobalConfig.HL7Client:
                        serviceName = ProdHL7Dispatcher;
                        break;
                }
            }
            else
            {
                switch (serv)
                {
                    case Common.ApplicationNameGlobalConfig.HL7Service:
                        serviceName = TestHL7Service;
                        break;
                    case Common.ApplicationNameGlobalConfig.VistaLinkService:
                        serviceName = TestVistaService;
                        break;
                    case Common.ApplicationNameGlobalConfig.HL7Client:
                        serviceName = TestHL7Dispatcher;
                        break;
                }
            }

            ServiceController service = new ServiceController(serviceName);

            try
            {
                switch (service.Status)
                {
                    case ServiceControllerStatus.Running:           // This is what we expect; the service should be running.
                    case ServiceControllerStatus.ContinuePending:
                    case ServiceControllerStatus.Paused:
                    case ServiceControllerStatus.PausePending:
                    case ServiceControllerStatus.StartPending:
                    case ServiceControllerStatus.StopPending:
                        service.Stop();
                        service.WaitForStatus(ServiceControllerStatus.Stopped, new TimeSpan(0, 0, 10));  // wait up to 10 seconds for the service to stop. 

                        if (service.Status == ServiceControllerStatus.Stopped)
                        {
                            service.Start();
                            service.WaitForStatus(ServiceControllerStatus.Running, new TimeSpan(0, 0, 10));
                            return (service.Status == ServiceControllerStatus.Running);
                        }
                        else
                        {
                            return false;
                        }

                    case ServiceControllerStatus.Stopped:
                        service.Start();
                        service.WaitForStatus(ServiceControllerStatus.Running, new TimeSpan(0, 0, 10));
                        return (service.Status == ServiceControllerStatus.Running);
                    default:
                        return false;

                }
            }
            // We could be here for any number of reasons:
            // 1) This is running on a machine that doesn't have the services installed.
            // 2) The user doesn't have permission to manipulate the services.
            catch (Exception)
            {
                return false;
            }
        }


        ///<Developers>
        ///	<Developer>Carl Jensen</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>4/16/2014</CreationDate>
        ///
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Checks if the parameter against the Application Sever IP, and returrns true if equal CR3419
        /// </summary>
        public static bool IsApplicationServerIP(string configuredIP)
        {
            string host = System.Net.Dns.GetHostName();
                       
            // Get the IP from the host name
            for (int i = 0; i < System.Net.Dns.GetHostEntry(host).AddressList.GetLength(0); i++)
            {
                string ip = System.Net.Dns.GetHostEntry(host).AddressList[i].ToString();
                if (ip.Equals(configuredIP)) return true;
            }

            return false;
        }


        ///<Developers>
        ///	<Developer>Carl Jensen</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/16/2014</CreationDate>
        ///
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Get's the servers IPv4 address
        /// </summary>
        public static string GetServerIPv4()
        {
            string host = System.Net.Dns.GetHostName();

            // Get the IP from the host name
            for (int i = 0; i < System.Net.Dns.GetHostEntry(host).AddressList.GetLength(0); i++)
            {
                string ip = System.Net.Dns.GetHostEntry(host).AddressList[i].ToString().Trim();

                if (Common.RegularExpressions.IPAddress().IsMatch(ip))
                    return ip;
            }
            return string.Empty;
        }


        ///<Developers>
        ///	<Developer>Carl Jensen</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/16/2014</CreationDate>
        ///
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Get's the servers IPv6 address
        /// </summary>
        public static string GetServerIPv6()
        {
            string host = System.Net.Dns.GetHostName();

            // Get the IP from the host name
            for (int i = 0; i < System.Net.Dns.GetHostEntry(host).AddressList.GetLength(0); i++)
            {
                string ip = System.Net.Dns.GetHostEntry(host).AddressList[i].ToString().Trim();

                if (!Common.RegularExpressions.IPAddress().IsMatch(ip))
                    return ip;
            }
            return string.Empty;
        }

		#endregion
	}
}